//
//  THViewController.m
//  ViewRotator
//
//  Created by Andrew Chalkley on 4/30/14.
//  Copyright (c) 2014 Andrew Chalkley. All rights reserved.
//

#import "THViewController.h"
#import <CoreMotion/CoreMotion.h>

@interface THViewController ()
    @property (nonatomic, assign) CGFloat angle;
    @property (weak, nonatomic) IBOutlet UILabel *xLabel;
    @property (weak, nonatomic) IBOutlet UILabel *yLabel;
    @property (weak, nonatomic) IBOutlet UILabel *zLabel;
    @property (nonatomic, strong) CMMotionManager *motionManager;
@end

@implementation THViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    [NSTimer scheduledTimerWithTimeInterval:0.01 target:self selector:@selector(rotateView) userInfo:nil repeats:YES];
    [NSTimer scheduledTimerWithTimeInterval:0.1 target:self selector:@selector(updateDebug) userInfo:nil repeats:YES];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void) rotateView {
    self.angle = self.angle + (M_PI / 180 * self.motionManager.accelerometerData.acceleration.x);
    self.rotateMeView.transform = CGAffineTransformMakeRotation(self.angle);
}

- (BOOL) shouldAutorotate {
    return FALSE;
}

- (void) updateDebug {
    if (self.motionManager.accelerometerActive) {
        self.xLabel.text = [NSString stringWithFormat:@"x: %g", self.motionManager.accelerometerData.acceleration.x];
        self.yLabel.text = [NSString stringWithFormat:@"y: %g", self.motionManager.accelerometerData.acceleration.y];
        self.zLabel.text = [NSString stringWithFormat:@"z: %g", self.motionManager.accelerometerData.acceleration.z];
    }
}

-(void) viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self.motionManager startAccelerometerUpdates];
}

-(void) viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self.motionManager stopAccelerometerUpdates];
}

- (CMMotionManager *) motionManager {
    if(_motionManager != nil) {
        return _motionManager;
    }
    
    _motionManager = [[CMMotionManager alloc] init];
    return _motionManager;
}

- (CGFloat) angle {
    if ( _angle != 0 ){
        return _angle;
    }
    
    _angle = 2 * M_PI;
    
    return _angle;
}



@end
