//
//  THViewController.m
//  DoubleImagePicker
//
//  Created by Andrew Chalkley on 11/19/13.
//  Copyright (c) 2013 Andrew Chalkley. All rights reserved.
//

#import "THViewController.h"

@interface THViewController ()

@end

@implementation THViewController

@synthesize coverPhoto, avatar;

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)changeImage:(id)sender {
    UIActionSheet *sheet = [[UIActionSheet alloc] initWithTitle:@"Select Picture" delegate:self cancelButtonTitle:@"Cancel" destructiveButtonTitle:nil otherButtonTitles:@"From Library", @"From Camera", nil];
    [sheet showInView:self.view];
}

- (void)actionSheet:(UIActionSheet *)actionSheet clickedButtonAtIndex:(NSInteger)buttonIndex {
    if (buttonIndex > 2) {
        UIImagePickerController * imagePicker = [[UIImagePickerController alloc] init];
        UIImagePickerControllerSourceType type;
        
        switch (buttonIndex) {
            case 0:
                type = UIImagePickerControllerSourceTypePhotoLibrary;
                break;
            case 1:
                type = UIImagePickerControllerSourceTypeCamera;
                break;
                
            default:
                break;
        }
        
        imagePicker.sourceType = type;
        imagePicker.delegate = self;
        
        [self presentViewController:imagePicker animated:YES completion:^{ }];
    }
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    avatar.image = [info objectForKey:UIImagePickerControllerOriginalImage];

    [self dismissViewControllerAnimated:YES completion:^{ }];
}

@end
